import Utilities.visa_operations as vo
import Utilities.gui_creator as gc

root = gc.create_window(title='Simple VISA Query',
                        size='700x450')

resource_name = \
           'USB0::0x0957::0x0607::MY47022122::INSTR'

rm, dmm = vo.open_session(resource_name)

def perform_query():

    ent_string = gc.get_control_string(var_ent)
    vo.write_instrument(dmm, ent_string)
    response = vo.read_instrument(dmm)
    response = response[:-1]
    stx.delete(1.0, 'end')
    stx.insert(1.0, response)

    return

var_ent = gc.create_control(root, label='Command',
                            char_width=60)

stx = gc.create_text_box(root, label='Response',
                         char_width=55, lines=20)

btn = gc.action_button(root, label='Submit',
                       action=perform_query)

root.mainloop()

vo.close_session(rm, dmm)

